<?php

namespace Wolfie\Models;

use Illuminate\Database\Eloquent\Model;

class Service extends Model 
{

    protected $table = 'services';
    public $timestamps = true;
    protected $fillable = array('label', 'slug', 'credits', 'parent_id', 'lft', 'rgt', 'image');
    protected $visible = array('image');

    public function pros()
    {
        return $this->belongsToMany('Pro', 'pro_service', 'service_id', 'pro_id');
    }

    public function data()
    {
        return $this->hasMany('ServiceData', 'service_id');
    }

    public function ads()
    {
        return $this->hasMany('Ad', 'service_id');
    }

}